//
//  InterfaceController.swift
//  MapViewTest WatchKit Extension
//
//  Created by Alexander Clauss on 11.04.22.
//

import WatchKit
import MapKit


class InterfaceController: WKInterfaceController {

    @IBOutlet weak var mapView: WKInterfaceMap!
    @IBOutlet weak var pickerView: WKInterfacePicker!
    
    private let minZoomLevel = 4.0
    private let maxZoomLevel = 18.0
    private let equatorLength = 40075000.0
    private var zoomLevel = 10.0

    private var touchPoint = CGPoint()
    private var location = CLLocationCoordinate2D(latitude: 49, longitude: 9)

    var visibleDistance:Double { equatorLength / pow(2, zoomLevel) }

    
    override func awake(withContext context: Any?) {
        let pickerItem = WKPickerItem()
        let pickerItems = [WKPickerItem](repeatElement(pickerItem, count: Int(maxZoomLevel-minZoomLevel)*2))
        self.pickerView.setItems(pickerItems)
        self.pickerView.setHeight(0)
        self.pickerView.setSelectedItemIndex(Int((self.zoomLevel - self.minZoomLevel) * 2))
    }
        

    private func setupMap() {
        let range = self.visibleDistance
        let region =  MKCoordinateRegion(center: self.location, latitudinalMeters: range, longitudinalMeters: range)
        self.mapView.setRegion(region)
    }

    
    @IBAction func scrollAction(_ sender: WKPanGestureRecognizer) {
        let pt = sender.locationInObject()
        if sender.state == .began {
            self.touchPoint = pt
            
        } else {
            let screenSize = WKInterfaceDevice.current().screenBounds.size
            let range = self.visibleDistance
                
            let x = (self.touchPoint.x - pt.x) / screenSize.width * range
            let y = (self.touchPoint.y - pt.y) / screenSize.width * range
                
            let R:CGFloat = 111111
            var dY = y/R
            var dX = x/(R*cos(self.location.latitude/180 * Double.pi))

            while self.location.longitude + dX < -180 { dX += 360 }
            while self.location.longitude + dX > 180  { dX -= 360 }
                
            if self.location.latitude - dY > 75  { dY = self.location.latitude - 75 }
            if self.location.latitude - dY < -75 { dY = self.location.latitude + 75 }

            self.touchPoint = pt

            self.location.longitude += dX
            self.location.latitude -= dY
            self.setupMap()
        }
    }
    
    @IBAction func zoomAction(_ value: Int) {
        self.zoomLevel = Double(value) / 2 + self.minZoomLevel
        self.setupMap()
    }
}
